/**
 * \file: exchnd.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * Exchnd - Common declaration to all the daemon components.
 *
 * \component: exchndd
 *
 * \copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef _EXCHNDD_H
#define _EXCHNDD_H

#include <stdint.h>

#include "exchnd_interface.h"

enum EXCHND_ACTION {
    EXCHND_HELP_BIT = 0,
    EXCHND_DEMONIZE_BIT,
    EXCHND_SMOKETEST_BIT,
    EXCHND_TERMINATE_BIT,
    EXCHND_SHUTDOWN_BIT,
    EXCHND_KILL_BIT,
    EXCHND_EXT_STACK_BIT,
    EXCHND_EXT_BT_BIT,
    EXCHND_EXT_BT_ALL_BIT,
    EXCHND_EXT_BT_FALLBACK_BIT,
    EXCHND_FRAME_BT_FALLBACK_BIT,
    EXCHND_GUESS_FALLBACK_BIT,
    EXCHND_SERVER_BIT,
    EXCHND_MAX_BT_DEPTH_BIT,
    EXCHND_NO_ACTION_BIT
};

#define EXCHND_HELP                 (1 << EXCHND_HELP_BIT)
#define EXCHND_DEMONIZE             (1 << EXCHND_DEMONIZE_BIT)
#define EXCHND_SMOKETEST            (1 << EXCHND_SMOKETEST_BIT)
#define EXCHND_TERMINATE            (1 << EXCHND_TERMINATE_BIT)
#define EXCHND_SHUTDOWN             (1 << EXCHND_SHUTDOWN_BIT)
#define EXCHND_KILL                 (1 << EXCHND_KILL_BIT)
#define EXCHND_EXT_STACK            (1 << EXCHND_EXT_STACK_BIT)
#define EXCHND_EXT_BT               (1 << EXCHND_EXT_BT_BIT)
#define EXCHND_EXT_BT_ALL           (1 << EXCHND_EXT_BT_ALL_BIT)
#define EXCHND_EXT_BT_FALLBACK      (1 << EXCHND_EXT_BT_FALLBACK_BIT)
#define EXCHND_FRAME_BT_FALLBACK    (1 << EXCHND_FRAME_BT_FALLBACK_BIT)
#define EXCHND_GUESS_FALLBACK       (1 << EXCHND_GUESS_FALLBACK_BIT)
#define EXCHND_SERVER               (1 << EXCHND_SERVER_BIT)
#define EXCHND_MAX_BT_DEPTH         (1 << EXCHND_MAX_BT_DEPTH_BIT)
#define EXCHND_NO_ACTION            (1 << EXCHND_NO_ACTION_BIT)

/* Fixing max length to 1KB */
#define MAX_MSG_LEN 1024
#define SHRT_MSG_LEN 256

#define STRINGIFY2(name)        # name
#define STRINGIFY(name)         STRINGIFY2(name)

#define ARG_CNT 12

#define EXCH_KB         1024
#define EXCH_POOL       1024
#define MEMORY_POOL     (EXCH_POOL * EXCH_KB)      /* 1 MB is enough for now. */
#define EXCH_STACK_SIZE (EXCH_POOL * EXCH_KB)      /* 1 MB is enough for now. */

#define MAX_BACKTRACE_DEPTH 32

extern long action;
extern int guess_size;
extern int max_bt_depth;

void exchnd_touch_wd(int, unsigned int);
void exchnd_ping_driver();

void exchnd_init_scheduling(void);

#define EXH_NORMAL_TH       0
#define EXH_INIT_PROCESS_TH 1
#define EXH_PROCESS_TH      2

int exchnd_create_thread(pthread_t *, void *(*f)(void *), void *, int);

/* exchnd_print_error - write an error message */
void exchnd_print_error(const char *format, ...);
void show_new_pagefault_count(const char *, const char *, const char *);

void set_client_name(char *);
int exchnd_init_server(void);
void exchnd_cleanup_server(void);
void exchnd_server_add_msg(pid_t, char *);

int exchnd_init_processing(ExchndInterface_t *);
void exchnd_deinit_processing(void);

int exchnd_handle_event(void);

void exchnd_prepare_pool(void);
void exchnd_prepare_malloc(void);
int exchnd_lock_memory(int memory_pool);
void exchnd_mem_rellock(void);
void exchnd_unlock_memory(void);

/* List manipulation */
struct msg_list {
    struct msg_list *next;
    struct msg_list *prev;
    char *msg;
    int len;
    int read_flag;
    pthread_mutex_t msg_lck;
};

void exchnd_init_list(struct msg_list *);
void exchnd_list_del(struct msg_list *);
void exchnd_list_add_tail(struct msg_list *, struct msg_list *);

#define MAX_SIZE 64

struct exchnd_file {
    int fd;
    int len;
    char *curr;
    char local[MAX_SIZE];
};

char *exchnd_fgets(char *, int, struct exchnd_file *);
void exchnd_init_file(struct exchnd_file *);
void exchnd_close(struct exchnd_file *);

struct ptrace_peeksiginfo_args {
    uint64_t off;   /* Ordinal position in queue at which
                     * to start copying signals */
    uint32_t flags; /* PTRACE_PEEKSIGINFO_SHARED or 0 */
    int32_t nr;     /* Number of signals to copy */
};

#endif /* _EXCHNDD_H */
